﻿var dashboardResults =
{
    language: 'en',
    mainSection: null,
    questionNavigator: null,
    questionNavigatorTable: null,
    questionsSection: null,
    questions: new Array(),
    sentimentAnalysis: null,
    isSentimentVisible: false,
    sentimentAnalysisTable: null,
    selectedQuestion: null,
    selectedQnFeedbackQuestions: null,
    selectedVariableName: "",
    selectedVariableId: 0,
    selectedQnDescription: "",
    isSentimentWidgetInitialLoadingCompleted: false
}

$(document).ready(function () {
    dashboardLoadResultsConfiguration();
    if (dashboardResults.mainSection.length > 0) {
        dashboardBindQuestionNavigator();
    }
});

$('.dashboard-activate-survey').on("click", function () {
    var parameters = {
        surveyId: a4.getSurveyId()
    };
    var hasActivated = a4.getAction("StartAndDeploySurvey", "Shared", 'Survey');
    a4.callServerMethod(hasActivated, parameters, function (result) {
        if (result['success']) {
            window.location.reload();
        }
    });
});

function dashboardLoadResultsConfiguration() {
    dashboardResults.mainSection = $(".nps-resultsDashboard");
    var configurationSection = $(".v-configurationDashboard", dashboardResults.mainSection);
    dashboardResults.language = $("#userLanguage", configurationSection).val();
}

function loadLastSelectedQuestionFromConfig(attemptNum) {
    var qnsTableCheckInterval;
    if (dashboardResults.selectedVariableId > 0 || npsDashboardQuestionConfig) {
        var variableIdOfQuestionTobeLoaded = dashboardResults.selectedVariableId > 0 ? dashboardResults.selectedVariableId : npsDashboardQuestionConfig.VariableId;
        qnsTableCheckInterval = setInterval(function () {
            if ($('tbody>tr', '.h-questionNavigatorDashboard-table').length > 0) {
                clearInterval(qnsTableCheckInterval);
                loadLastSelectedQuestion(variableIdOfQuestionTobeLoaded, attemptNum);
            }
        }, 1000);
    }
}

function loadLastSelectedQuestion(variableIdOfQuestionTobeLoaded, attemptNum) {
    var allLoadedQuestions = $('tbody>tr', '.h-questionNavigatorDashboard-table');
    var selectedQuestion = null;
    _.find(allLoadedQuestions, function (item) {
        var currentQn = $(item);
        if (currentQn.data("variableId") === variableIdOfQuestionTobeLoaded) {
            selectedQuestion = currentQn;
            return true;
        }
        return false;
    });
    if (selectedQuestion) {
        selectCurrentRowAndShowDashboard(selectedQuestion, false);
        selectedQuestion.get(0).scrollIntoView();
    }
    else if (attemptNum <= 3) {
        loadLastSelectedQuestionFromConfig(attemptNum + 1);
    }
}

function dashboardBindQuestionNavigator() {
    dashboardResults.questionNavigator = $(".h-questionNavigatorDashboard");
    dashboardResults.questionNavigatorTable = $(".h-questionNavigatorDashboard-table", dashboardResults.questionNavigator).a4datatable({
        ajaxAction: a4.getSurveyAction("GetQuestionsForNpsAnalytics", "NpsAnalytics"),
        ajaxParams: { "language": dashboardResults.language },

        columns: [
            {
                "Name": "QuestionDefinition",
                "Title": "",
                "Data": function (source, type, val) {
                    var statusIcon = $("<div>").addClass("dashboard-status-icon");
                    if (source['HasDashboard']) {
                        $(statusIcon).append($("<i>")).addClass("fa fa-pie-chart");
                    }

                    var jqhtml = $("<div>")
                        .append($("<div>").addClass("question h-goToQuestionDashboard")
                            .attr("title", source.Text)
                            .append($(statusIcon))
                            .append($("<div>").addClass("question-labels-container")
                                .append($("<div>").addClass("name").append(source.Name))
                                .append($("<div>").addClass("text").append(source.Text)))
                        );
                    return jqhtml.html();
                }
            }
        ],

        localizableTexts: { "Search": resources.SearchQuestions },
        allowRowSelection: false,
        displayColumnSelector: false,

        rowCreated: function (event, d) {
            var currentRow = $(d.row);
            currentRow.data("id", d.data.Id);
            currentRow.data("variableId", d.data.Variables[0] ? d.data.Variables[0].SourceKey : 0);
            currentRow.data("variableName", d.data.Variables[0] ? d.data.Variables[0].Name : '');
            currentRow.data("description", d.data.Text);
            currentRow.data("name", d.data.Name);
            currentRow.data("position", d.data.Position);
            currentRow.data("typeValue", d.data.TypeValue);
            currentRow.data("hasResponses", d.data.HasResponses);
            currentRow.data("hasDashboard", d.data.HasDashboard);
            currentRow.data("linkedQuestions", d.data.LinkedQuestions);
            currentRow.data("hasSentimentAnalysis", d.data.HasSentimentAnalysis);
            currentRow.data("hasTopicAnalysis", d.data.HasTopicAnalysis);
        },
        customCallback: function () { loadLastSelectedQuestionFromConfig(1); }
    });

    $(".h-refreshButton", dashboardResults.questionNavigatorTable).on("click", function () {
        showInitialInstructions();
    });

    // Handle when click on the question row in questions panel
    $(dashboardResults.questionNavigator).on("click", ".h-goToQuestionDashboard", function (e) {
        var row = $(this).parents("tr");
        selectCurrentRowAndShowDashboard(row, true);
    });
}

function selectCurrentRowAndShowDashboard(currentRow, updateConfig) {
    // Clear the dashboard before showing any results
    showInitialInstructions();

    dashboardResults.selectedQuestion = currentRow;
    dashboardResults.selectedVariableId = currentRow.data("variableId");
    dashboardResults.selectedVariableName = currentRow.data("variableName");
    dashboardResults.selectedQnDescription = currentRow.data("description");

    var selectedElements = $(".selected", dashboardResults.questionNavigatorTable);
    if (selectedElements && selectedElements.length > 0) {
        selectedElements[0].className = selectedElements[0].classList[0];
    }

    if (currentRow.data("typeValue") === 30) {
        displayDashboardForNpsQuestion(currentRow, updateConfig);
    }
}

function displayDashboardForNpsQuestion(row, updateConfig) {
    var hasDashboardExistsForNpsQn = row.data("hasDashboard");
    var isLoaderRequired = false;

    // Setting the default frequency for the Sentiment TrendChart when newly showing the dashboard details for the question
    $(".nps-trendChart-frequency", $(".nps-TrendChart")).prop("selectedIndex", 0).val();

    if (!hasDashboardExistsForNpsQn) {
        if (!canCreateDashboards) {
            a4.showErrorMessage(createDashboardResources.CreateDashboardPermissionDenied);
        }
        else {
            // When we are trying to create the dashboard for first time, if we click on the confirm dashboard button immediately, the dashboard construction is starting and
            // at the same time we are getting another popup for dashboard creation(It is only happening in very few cases). Adding the below condition to avoid that.
            if ($('.dashboard-container').is(":visible")) {
                return;
            }

            a4.callServerMethod(a4.getSurveyAction("HasNpsQuestionResponses", "NPSAnalytics"), {
                questionName: row.data("variableName"),
            }, function (response) {
                if (!response) {
                    a4.showErrorMessage(createDashboardResources.QuestionHasNoResponses);
                }
                else {
                    showLoadingAnimation();
                    setCurrentRowSelected(row);
                    renderNpsAndSetimentWidgets(row, updateConfig);
                    isLoaderRequired = true;
                    if (!isLoaderRequired) {
                        hideLoader();
                        $("#initialInstructions").show();
                    }
                }
            })
        }
    }
    else {
        setCurrentRowSelected(row);
        renderNpsAndSetimentWidgets(row, updateConfig);
    }
}

function setCurrentRowSelected(row) {
    var selectedElements = $(".selected", dashboardResults.questionNavigatorTable);
    if (selectedElements && selectedElements.length > 0) {
        selectedElements[0].className = selectedElements[0].classList[0];
    }
    row.toggleClass("selected");
    $(".filterIconDiv").removeClass("hideFilterIcon");
}

function renderNpsAndSetimentWidgets(row, updateConfig) {
    showLoadingAnimation();

    // Enable the 'Export' button
    $("#btnNpsExport", "#main-header").show();

    var hasNpsHaveFeedbackQns = row.data("linkedQuestions") && row.data("linkedQuestions").length > 0;
    var hasNpsHaveMultiFeedbackQns = row.data("linkedQuestions") && row.data("linkedQuestions").length > 1;
    dashboardResults.selectedQnFeedbackQuestions = row.data("linkedQuestions");
    var hasSentimentAnalysis = row.data("hasSentimentAnalysis");
    var hasTopicAnalysis = row.data("hasTopicAnalysis");
    filterAnalytics = {};
    // Render required NPS charts by getting the data
    a4.callServerMethod(a4.getSurveyAction("GetDataForNpsDashboardWidgets", "NpsAnalytics"), {
        variableName: row.data("variableName"),
        variableId: row.data("variableId"),
        "filterAnalytics": filterAnalytics,
        updateConfig: updateConfig
    }, function (response) {
        // Enable the dashboard icon when the NPS charts are ready for first time NPS dashboard loading
        if (!$(".dashboard-status-icon", row).hasClass("fa fa-pie-chart")) {
            $(".dashboard-status-icon", row).addClass("fa fa-pie-chart");
        }
        // Setting the dashboard availability for NPS question
        row.data("hasDashboard", true);

        hideLoader();
        showDashboard();
        setDashboardInfo(row.data("variableName"), response['LastUpdatedDateTime']);
        renderPieChart(response['NpsScore']);
        renderDistributionChart(response['DistributionChartItems']);
        renderTrendChart(response['NpsTrendData']);
        getFilterData(response['FilterAnalytics'], true);
    });

    if (!hasSentimentAnalysis && !hasTopicAnalysis) {
        hideSentimentWidget();
    } else {
        if (hasNpsHaveFeedbackQns) {
            // Make sure that we have enabled the display of the widget
            showSentimentWidget(hasNpsHaveMultiFeedbackQns, hasTopicAnalysis);

            // Render 'Sentiment Analysis' widget
            filterFeedbackQnAndLoadSentimentAnalysisWidget(true, hasTopicAnalysis);
        }
        else {
            // In case of no dashboard, make the NPS charts fit to full screen and hide the sentiment widget
            hideSentimentWidget();
        }
    }
}

function filterFeedbackQnAndLoadSentimentAnalysisWidget(isInitialLoading, hasTopicAnalysis, filterAnalytics) {
    var requiredQuestionIndex = 0;
    let requiredFeedBackQn = _.find(dashboardResults.selectedQnFeedbackQuestions, function (qn) {
        let qnDashboardExists = qn.HasDashboard;

        requiredQuestionIndex = requiredQuestionIndex + 1;
        return qnDashboardExists;
    });

    if (requiredFeedBackQn === undefined) {
        hideSentimentWidget();
        return;
    }

    // Updating the sentiment feedback question drop down with appropriate feedback question
    $(".sentiment-analysis-filter", $(".setiment-analysis")).prop("selectedIndex", requiredQuestionIndex - 1).val();

    // Load Sentiment analysis widget
    displaySentimentAnalysisWidget(isInitialLoading, requiredFeedBackQn, hasTopicAnalysis, filterAnalytics);
}

function displaySentimentAnalysisWidget(isInitialLoading, requiredFeedBackQn, hasTopicAnalysis, filterAnalytics) {
    dashboardResults.sentimentAnalysis = $(".setiment-analysis");
    var variableId = requiredFeedBackQn.Variables[0] ? requiredFeedBackQn.Variables[0].SourceKey : 0;

    $(".statusMessage", $(".setiment-analysis")).hide();
    $(".card-body", $(".setiment-analysis")).show();

    updateTextAnalysisRedirectUrl(variableId);
    getSentimentAnalysisResponseCounts(variableId, filterAnalytics);
    if (hasTopicAnalysis) {
        getSentimentTopicsResult(variableId);
    } else {
        getOpenEndAnswerResults(variableId, filterAnalytics);
    }

    if (isInitialLoading) {
        dashboardResults.isSentimentWidgetInitialLoadingCompleted = true;
    }
}

$(".sentiment-analysis-filter", $(".setiment-analysis")).on("change", function () {
    if (!dashboardResults.isSentimentWidgetInitialLoadingCompleted) {
        return false;
    }

    var feedbackType = $(".sentiment-analysis-filter", $(".setiment-analysis")).val();
    $(".nps-topic-sentimetOptions").prop("selectedIndex", 0).val();

    switch (feedbackType) {
        case "PROMOTERS":
            // Setting status message
            $(".statusMessage", $(".setiment-analysis")).text(createDashboardResources.NpsNoResponsesAnalysedForPromoters);

            var requiredFeedbackQuestion = dashboardResults.selectedQuestion.data("linkedQuestions")[0];
            checkAvailabilityAndDisplaySentimentAnalysisWidget(requiredFeedbackQuestion);
            break;
        case "PASSIVES":
            // Setting status message
            $(".statusMessage", $(".setiment-analysis")).text(createDashboardResources.NpsNoResponsesAnalysedForPassives);

            var requiredFeedbackQuestion = dashboardResults.selectedQuestion.data("linkedQuestions")[1];
            checkAvailabilityAndDisplaySentimentAnalysisWidget(requiredFeedbackQuestion);
            break;
        case "DETRACTORS":
            // Setting status message
            $(".statusMessage", $(".setiment-analysis")).text(createDashboardResources.NpsNoResponsesAnalysedForDetractors);

            var requiredFeedbackQuestion = dashboardResults.selectedQuestion.data("linkedQuestions")[2];
            checkAvailabilityAndDisplaySentimentAnalysisWidget(requiredFeedbackQuestion);
            break;
    }
});

function checkAvailabilityAndDisplaySentimentAnalysisWidget(qn) {
    let qnDashboardExists = qn.HasDashboard;
    let qnDashaboardStatus = qn.DashboardStatus;

    if (!qnDashboardExists || qnDashaboardStatus !== "Completed") {
        // Hide contents of the widget
        if (!$(".card-body", $(".setiment-analysis")).hasClass('dis-n')) {
            $(".card-body", $(".setiment-analysis")).addClass("dis-n");
        }
        // Enable status message
        $(".statusMessage", $(".setiment-analysis")).show();

        return;
    }

    displaySentimentAnalysisWidget(false, qn, qn.HasTopicAnalysis, filterAnalytics);
}

function updateTextAnalysisRedirectUrl(variableId) {
    var updatedRedirectUrl;
    var redirectUrl = $("#redirectToTextAnalysis", $(".setiment-analysis")).attr("href");
    let urlParts = redirectUrl.split('?');
    if (urlParts && urlParts.length > 1) {
        updatedRedirectUrl = urlParts[0].concat("?defaultVariableId=", variableId);
    }
    else {
        updatedRedirectUrl = redirectUrl.concat("?defaultVariableId=", variableId);
    }

    $("#redirectToTextAnalysis", $(".setiment-analysis")).attr("href", updatedRedirectUrl);
}

function getSentimentAnalysisResponseCounts(variableId, filterAnalytics) {
    a4.callServerMethod(a4.getSurveyAction("GetSentimentAnalysisCounts", "AdvancedAnalytics"), {
        variableId: variableId,
        "filterVariableId": dashboardResults.selectedVariableId,
        "filterAnalytics": filterAnalytics
    }, function (response) {
        if (response.length == 0) {
            var feedbackType = $(".sentiment-analysis-filter", $(".setiment-analysis")).val();
            switch (feedbackType) {
                case "PROMOTERS":
                    $(".statusMessage", $(".setiment-analysis")).text(createDashboardResources.NpsNoResponsesAnalysedForPromoters);
                    break;
                case "PASSIVES":
                    $(".statusMessage", $(".setiment-analysis")).text(createDashboardResources.NpsNoResponsesAnalysedForPassives);
                    break;
                case "DETRACTORS":
                    $(".statusMessage", $(".setiment-analysis")).text(createDashboardResources.NpsNoResponsesAnalysedForDetractors);
                    break;
            }
            if (!$(".card-body", $(".setiment-analysis")).hasClass('dis-n')) {
                $(".card-body", $(".setiment-analysis")).addClass("dis-n");
            }
            $(".statusMessage", $(".setiment-analysis")).show();
        } else {
            if ($(".card-body", $(".setiment-analysis")).hasClass('dis-n')) {
                $(".card-body", $(".setiment-analysis")).removeClass("dis-n");
            }

            var positiveCount = getSentimentCountByCategory(response, resources.Positive);
            var neutralCount = getSentimentCountByCategory(response, resources.Neutral);
            var negativeCount = getSentimentCountByCategory(response, resources.Negative);
            var totalCount = positiveCount + neutralCount + negativeCount;

            $(".count-all").text(totalCount);
            $(".count-positive").text(positiveCount);
            $(".count-neutral").text(neutralCount);
            $(".count-negative").text(negativeCount);
        }
    });
}

var persistTopicsForFilter = [];
function getSentimentTopicsResult(variableId) {
    a4.callServerMethod(a4.getSurveyAction("GetSentimentTopicData", "AdvancedAnalytics"), {
        variableId: variableId,
        "filterVariableId": dashboardResults.selectedVariableId,
        "filterAnalytics": filterAnalytics
    }, function (response) {
        persistTopicsForFilter = response;
        renderSentimentTopics(response);
    });
}

function renderSentimentTopics(topics) {
    var table = $("<table>").addClass("compact dataTable no-footer").addClass("nps-topic-table");
    if (topics.length > 0) {
        for (var index = 0; index < topics.length; index++) {
            var topicName = topics[index]['TopicName'];
            var positive = topics[index]['Positive'] ? topics[index]['Positive'] : 0;
            var negative = topics[index]['Negative'] ? topics[index]['Negative'] : 0;
            var neutral = topics[index]['Neutral'] ? topics[index]['Neutral'] : 0;
            var total = positive + negative + neutral;
            var positiveWidthPercentage = (positive / total) * 100 + "%";
            var negativeWidthPercentage = (negative / total) * 100 + "%";
            var neutralWidthPercentage = (neutral / total) * 100 + "%";

            var row = $("<tr>");
            var displayTotal = "(" + total + ")";
            var nameCell = $("<td>").addClass("nps-topic-name").append(topicName + " " + displayTotal);

            var progressCell = $("<td>").addClass("nps-topic-progress")
                .append($("<div>").addClass("nps-topic-sentiment-proportions")
                    .append($("<div>").addClass("positive proportion").attr("style", "background:#43b17b;").attr("title", positive).width(positiveWidthPercentage))
                    .append($("<div>").addClass("neutral proportion").attr("style", "background:#33b6f0;").attr("title", neutral).width(neutralWidthPercentage))
                    .append($("<div>").addClass("negative proportion").attr("style", "background:#e94444;").attr("title", negative).width(negativeWidthPercentage)));

            row.append(nameCell)
                .append(progressCell)
            $(table).append(row);
            $(".nps-sentimet-analysis-topics-table").empty().append(table);
        }
    } else {
        $(table).append($("<div>").addClass("statusMessage").append(createDashboardResources.NpsNoTopicsForSentimentWidget));
        $(".nps-sentimet-analysis-topics-table").empty().append(table);
    }
}

$(".nps-topic-sentimetOptions").on("change", function () {
    var sentimentTopics = $(".nps-topic-sentimetOptions").val();

    if (persistTopicsForFilter.length != 0) {
        var filteredSentimentTopics = [];
        var sentimentValueArray = [];
        var maxValue = 0;

        if (sentimentTopics == "Positive" || sentimentTopics == "Negative" || sentimentTopics == "Neutral") {
            switch (sentimentTopics) {
                case "Positive":
                    $.each(persistTopicsForFilter, function (index, value) {
                        sentimentValueArray.push(value.Positive);
                    });
                    break;
                case "Negative":
                    $.each(persistTopicsForFilter, function (index, value) {
                        sentimentValueArray.push(value.Negative);
                    });
                    break;
                case "Neutral":
                    $.each(persistTopicsForFilter, function (index, value) {
                        sentimentValueArray.push(value.Neutral);
                    });
                    break;
            }
        }

        if (sentimentValueArray.length != 0) {
            maxValue = Math.max.apply(Math, sentimentValueArray);
        }

        switch (sentimentTopics) {
            case "Positive":
                $.each(persistTopicsForFilter, function (index, value) {
                    var sentimentTopicsData = {};
                    if (value.Positive > 0) {
                        sentimentTopicsData.TopicName = value.TopicName;
                        sentimentTopicsData.Positive = value.Positive;
                        var percentage = (value.Positive / maxValue) * 100;
                        sentimentTopicsData.Percentage = Number(percentage).toFixed(2) + "%";
                        filteredSentimentTopics.push(sentimentTopicsData);
                    }
                });
                filteredSentimentTopics.sort((a, b) => b.Positive - a.Positive);
                break;
            case "Negative":
                $.each(persistTopicsForFilter, function (index, value) {
                    var sentimentTopicsData = {};
                    if (value.Negative > 0) {
                        sentimentTopicsData.TopicName = value.TopicName;
                        sentimentTopicsData.Negative = value.Negative;
                        sentimentTopicsData.Percentage = (value.Negative / maxValue) * 100 + "%";
                        filteredSentimentTopics.push(sentimentTopicsData);
                    }
                });
                filteredSentimentTopics.sort((a, b) => b.Negative - a.Negative);
                break;
            case "Neutral":
                $.each(persistTopicsForFilter, function (index, value) {
                    var sentimentTopicsData = {};
                    if (value.Neutral > 0) {
                        sentimentTopicsData.TopicName = value.TopicName;
                        sentimentTopicsData.Neutral = value.Neutral;
                        sentimentTopicsData.Percentage = (value.Neutral / maxValue) * 100 + "%";
                        filteredSentimentTopics.push(sentimentTopicsData);
                    }
                });
                filteredSentimentTopics.sort((a, b) => b.Neutral - a.Neutral);
                break;
            default:
                $.each(persistTopicsForFilter, function (index, value) {
                    var sentimentTopicsData = {};
                    sentimentTopicsData.TopicName = value.TopicName;
                    sentimentTopicsData.Positive = value.Positive;
                    sentimentTopicsData.Negative = value.Negative;
                    sentimentTopicsData.Neutral = value.Neutral;
                    filteredSentimentTopics.push(sentimentTopicsData);
                });
        }

        if (sentimentTopics == "Positive" || sentimentTopics == "Negative" || sentimentTopics == "Neutral") {
            renderSentimentFilterTopics(filteredSentimentTopics, sentimentTopics);
        }
        else {
            renderSentimentTopics(filteredSentimentTopics);
        }
    }
});

function renderSentimentFilterTopics(topics, sentimentTopics) {
    $(".nps-sentimet-analysis-topics-table").empty();

    var table = $("<table>").addClass("compact dataTable no-footer").addClass("nps-topic-table");
    for (var index = 0; index < topics.length; index++) {
        var topicName = topics[index]['TopicName'];
        var positive = topics[index]['Positive'] ? topics[index]['Positive'] : 0;
        var negative = topics[index]['Negative'] ? topics[index]['Negative'] : 0;
        var neutral = topics[index]['Neutral'] ? topics[index]['Neutral'] : 0;
        var percentage = topics[index]['Percentage'] ? topics[index]['Percentage'] : 0;
        var positiveWidthPercentage = 0;
        var negativeWidthPercentage = 0;
        var neutralWidthPercentage = 0;
        var total = 0;

        switch (sentimentTopics) {
            case "Positive":
                var positiveWidthPercentage = percentage;
                total = positive;
                break;
            case "Negative":
                total = negative;
                var negativeWidthPercentage = percentage;
                break;
            case "Neutral":
                total = neutral;
                var neutralWidthPercentage = percentage;
                break;
        }

        var row = $("<tr>");
        var displayTotal = "(" + total + ")";
        var nameCell = $("<td>").addClass("nps-topic-name").append(topicName + " " + displayTotal);

        var progressCell = $("<td>").addClass("nps-topic-progress")
            .append($("<div>").addClass("nps-topic-sentiment-proportions")
                .append($("<div>").addClass("positive proportion").attr("style", "background:#43b17b;").attr("title", positive).width(positiveWidthPercentage))
                .append($("<div>").addClass("neutral proportion").attr("style", "background:#33b6f0;").attr("title", neutral).width(neutralWidthPercentage))
                .append($("<div>").addClass("negative proportion").attr("style", "background:#e94444;").attr("title", negative).width(negativeWidthPercentage)));

        row.append(nameCell)
            .append(progressCell)
        $(table).append(row);
        $(".nps-sentimet-analysis-topics-table").empty().append(table);
    }
}

function getSentimentCountByCategory(sentimentCounts, category) {
    var count = sentimentCounts
        .filter(function (sentimentCount) { return sentimentCount.Category == category })
        .reduce(function (counter, sentimentCount) { return counter + sentimentCount.Value }, 0);
    return count;
}

var series;
function renderPieChart(data) {
    var chart = am4core.create("pieChart", am4charts.PieChart);
    chart.data = data.NpsScoreItemsList;
    chart.numberFormatter.numberFormat = "#.";
    chart.innerRadius = am4core.percent(65);
    chart.radius = am4core.percent(95);

    series = chart.series.push(new am4charts.PieSeries());
    series.dataFields.value = "Value";
    series.dataFields.category = "Category";
    series.labels.template.disabled = true;
    series.tooltip.fontSize = 12;

    series.slices.template.propertyFields.fill = "Color";
    series.slices.template.propertyFields.isActive = "pulled";

    chart.legend = new am4charts.Legend();
    chart.legend.markers.template.disabled = true;
    chart.legend.labels.template.text = "[bold {color} font-size:14px]{value.percent.formatNumber('#.0')}%[/]\n{name}";
    chart.legend.valueLabels.template.text = "";
    chart.legend.position = "right";
    chart.legend.fontSize = 12;
    chart.legend.itemContainers.template.clickable = false;
    chart.legend.itemContainers.template.focusable = false;

    // Setting the NPS Score value at the middle of the pie chart
    var label = series.createChild(am4core.Label);
    label.text = data.NpsScore;
    label.fontSize = 30;
    label.horizontalCenter = "middle";
    label.verticalCenter = "middle";
    label.fill = "black";

    // Displaying values for additional legend
    $("#additionalLegend-text", $("#npsDashboardCharts")).text(resources.Responses);
    $("#additionalLegend-number", $("#npsDashboardCharts")).text(data.TotalResponses);
}

function renderDistributionChart(data) {
    var chart = am4core.create("distributionChart", am4charts.XYChart);
    chart.data = data;

    // Create axes
    var categoryAxis = chart.xAxes.push(new am4charts.CategoryAxis());
    categoryAxis.dataFields.category = "Label";
    categoryAxis.renderer.grid.template.location = 0;
    categoryAxis.renderer.minGridDistance = 0;
    categoryAxis.renderer.grid.template.disabled = true;
    categoryAxis.renderer.line.stroke = am4core.color("#CCCCCC");
    categoryAxis.renderer.fontSize = 11;
    configureChartAxisToolTip(categoryAxis);

    var valueAxis = chart.yAxes.push(new am4charts.ValueAxis());
    valueAxis.renderer.line.strokeOpacity = .2;
    valueAxis.min = 0;
    valueAxis.renderer.fontSize = 11;
    configureChartAxisToolTip(valueAxis);

    // Create series
    var series = chart.series.push(new am4charts.ColumnSeries());
    series.dataFields.valueY = "Count";
    series.dataFields.categoryX = "Label";
    series.tooltipText = "{Type}: [bold]{valueY}[/]";
    series.tooltip.fontSize = 11;
    series.columns.template.maxWidth = 30;
    series.columns.template.strokeWidth = 0;

    series.columns.template.adapter.add("fill", function (fill, target) {
        return target.dataItem._dataContext['Color'];
    });

    // Create labels
    var valueLabel = series.bullets.push(new am4charts.LabelBullet());
    valueLabel.label.text = "{valueY}";
    valueLabel.label.fontSize = 11;
    valueLabel.label.dx = 0;
    valueLabel.label.dy = -10;

    valueLabel.label.adapter.add("fill", function (fill, target) {
        return target.dataItem._dataContext['Color'];
    })

    // Add cursor
    chart.cursor = new am4charts.XYCursor();
}

function renderTrendChart(data, frequencyOption = 1) {
    // Create chart instance
    var chart = am4core.create("npsTrendChart", am4charts.XYChart);
    chart.data = data.NpsTrendItemList;
    chart.fontSize = 12;

    if (dashboardResults.language === "fr") {
        chart.dateFormatter.language = new am4core.Language();
        chart.dateFormatter.language.locale = am4lang_fr_FR;
    }

    // Create axes
    var dateAxis = chart.xAxes.push(new am4charts.DateAxis());
    configureChartAxisToolTip(dateAxis);

    switch (frequencyOption) {
        case "2":
            dateAxis.baseInterval = { "timeUnit": "month", "count": 1 };
            dateAxis.periodChangeDateFormats.setKey("month", "MMM yyyy");
            dateAxis.dateFormats.setKey("month", "MMM yyyy");
            dateAxis.tooltipDateFormat = "MMM yyyy";
            break;
        default:
            dateAxis.baseInterval = { "timeUnit": "day", "count": 1 };
            dateAxis.dateFormats.setKey("day", "MMM dd");
            dateAxis.tooltipDateFormat = "yyyy MMM dd";
            break;
    }

    // First value axis
    var valueAxis = chart.yAxes.push(new am4charts.ValueAxis());
    valueAxis.title.text = resources.NPS;
    valueAxis.fontSize = 11;
    configureChartAxisToolTip(valueAxis);

    // Second value axis
    var valueAxis2 = chart.yAxes.push(new am4charts.ValueAxis());
    valueAxis2.title.text = resources.Responses;
    valueAxis2.fontSize = 11;
    valueAxis2.renderer.opposite = true;
    configureChartAxisToolTip(valueAxis2);

    // First series
    var series = chart.series.push(new am4charts.ColumnSeries());
    series.dataFields.valueY = "ResponsesCount";
    series.dataFields.dateX = "Date";
    series.name = resources.Responses;
    series.fill = am4core.color("#3D8AB5");
    series.stroke = am4core.color("#3D8AB5");
    series.columns.template.width = 10;
    series.yAxis = valueAxis2;

    // Second series
    var series2 = chart.series.push(new am4charts.LineSeries());
    series2.dataFields.valueY = "NpsScore";
    series2.dataFields.dateX = "Date";
    series2.name = "NPS";
    series2.stroke = am4core.color("#007922");
    series2.strokeWidth = 2;
    series2.yAxis = valueAxis;

    // Set up common tooltip
    series.adapter.add("tooltipText", function (text) {
        var text = ""
        chart.series.each(function (item) {
            if (!item.isHidden) {
                text += item.name + ": [bold]{" + item.dataFields.valueY + "}[/]\n";
            }
        });
        return text;
    });
    series.tooltip.getFillFromObject = false;
    series.tooltip.background.fill = am4core.color("#E4F5FF");
    series.tooltip.background.stroke = am4core.color("#8C8C8C");
    series.tooltip.fontSize = 11;
    series.tooltip.label.fill = am4core.color("black");

    // Make bullets grow on hover
    var bullet = series2.bullets.push(new am4charts.CircleBullet());
    bullet.circle.strokeWidth = 1;
    bullet.circle.radius = 2;
    bullet.circle.fill = am4core.color("#EAEE15");

    var bullethover = bullet.states.create("hover");
    bullethover.properties.scale = 1.3;

    // Add legend
    chart.legend = new am4charts.Legend();
    chart.legend.fontSize = 11;
    chart.legend.position = "right";
    chart.legend.itemContainers.template.paddingBottom = 5;
    chart.legend.itemContainers.template.paddingRight = 0;
    chart.legend.maxWidth = 120;

    // Add cursor
    chart.cursor = new am4charts.XYCursor();
}

function configureChartAxisToolTip(axis) {
    /* Configure axis tooltip */
    var axisTooltip = axis.tooltip;
    axisTooltip.label.fill = am4core.color("black");
    axisTooltip.fontSize = 11;
    axisTooltip.background.fill = am4core.color("#B3DCFF");
    axisTooltip.background.strokeWidth = 0;
    axisTooltip.background.cornerRadius = 2;
    axisTooltip.background.pointerLength = 5;
    axisTooltip.dy = 0;

    /* Decorate axis tooltip content */
    axis.adapter.add("getTooltipText", function (text, target) {
        return "[bold]" + text + "[/]";
    });
}

$(".nps-trendChart-frequency", $(".nps-TrendChart")).on("change", function () {

    var frequencyOption = $(".nps-trendChart-frequency", $(".nps-TrendChart")).val();

    a4.callServerMethod(a4.getSurveyAction("GetNpsTrendChartData", "NpsAnalytics"), {
        variableName: dashboardResults.selectedQuestion.data("variableName"),
        frequencyOption: frequencyOption
    }, function (response) {
        renderTrendChart(response, frequencyOption);
    });
});

function showDashboard() {
    $("#initialInstructions").hide();
    $(".dashboard-container").show();
}

function showInitialInstructions() {
    $(".dashboard-container").hide();
    $("#initialInstructions").show();
}

function setDashboardInfo(dashboardName, updatedDate) {
    $(".dashboard-name").text(dashboardName);
    $(".dashboard-updated-date .updated-date").text(updatedDate);
}

function showSentimentWidget(hasNpsHaveMultiFeedbackQns, hasTopicAnalysis) {
    dashboardResults.isSentimentVisible = true;
    if ($(".card-body", $(".setiment-analysis")).hasClass('dis-n')) {
        $(".card-body", $(".setiment-analysis")).removeClass("dis-n");
    }

    if (hasNpsHaveMultiFeedbackQns) {
        $(".setiment-analysis .sentiment-analysis-filter").removeClass('dis-n');
    }
    else {
        $(".setiment-analysis .sentiment-analysis-filter").addClass('dis-n');
    }

    if (hasTopicAnalysis) {
        $(".sentimet-analysis-table").hide();
        $(".nps-topic-section").show();
        $(".nps-sentimet-analysis-topics-table").show();
        $(".nps-sentimet-analysis-topics-table").addClass("manage-topics-top-gap");
    } else {
        $(".sentimet-analysis-table").show();
        $(".sentimet-analysis-table").addClass("manage-response-top-gap");
        $(".sentimet-analysis-table .clearfix").hide();
        $(".nps-topic-section").hide();
        $(".nps-sentimet-analysis-topics-table").hide();
    }

    $(".setiment-analysis").show();
    $(".card-body", $(".setiment-analysis")).hide();
    $(".dashboard-charts").removeClass("fit-npsCharts-fullScreen");
    $(".dashboard-charts").addClass("fit-npsCharts-partOfScreen");
    $("#additionalLegend").removeClass("additionalLegend-fullScreen");
    $("#additionalLegend").addClass("additionalLegend-partialScreen");
}

function hideSentimentWidget() {
    dashboardResults.isSentimentVisible = false;

    $(".setiment-analysis").hide();
    $(".dashboard-charts").removeClass("fit-npsCharts-partOfScreen");
    $(".dashboard-charts").addClass("fit-npsCharts-fullScreen");
    $("#additionalLegend").addClass("additionalLegend-fullScreen");
    $("#additionalLegend").removeClass("additionalLegend-partialScreen");
}

// Export NPS Dashboard
$("#btnNpsExport").on("click", function () {
    var dialogContent = { iconRequired: true, Title: resources.ExportExcelHeader, Message: resources.NpsExportExcelConfirmationMsg, ConfirmButton: resources.Confirm };
    modalDialog.showConfirmDialog(dialogContent, function () { exportToExcel(); });
});

function exportToExcel() {
    showLoader(resources.ExportExcelLoadText);
    postNpsScoreImageToServer(1, ".pie-chart");

    function postNpsScoreImageToServer(chartType, selector) {
        html2canvas(document.querySelector(selector), { useCORS: true }).then(canvas => {
            var type = "png";
            var dataType = `image/${type}`;
            var imageContent = canvas.toDataURL(dataType).replace('data:' + dataType + ';base64,', '');

            var params = { surveyId: a4.getSurveyId(), npsChartType: chartType, imageContent: imageContent };
            var url = a4.getAction("SaveImagesForExportExcel", "NpsAnalytics", "Survey");

            a4.callServerMethod(url, params, function (response) {
                if (response["RequestId"] && response["RequestId"] !== "00000000-0000-0000-0000-000000000000") {
                    postNpsDistributionImageToServer(2, ".distribution-chart", response["RequestId"]);
                }
            });
        });
    }

    function postNpsDistributionImageToServer(chartType, selector, requestId) {
        html2canvas(document.querySelector(selector), { useCORS: true }).then(canvas => {
            var type = "png";
            var dataType = `image/${type}`;
            var imageContent = canvas.toDataURL(dataType).replace('data:' + dataType + ';base64,', '');

            var params = { surveyId: a4.getSurveyId(), npsChartType: chartType, imageContent: imageContent, inputRequestId: requestId };
            var url = a4.getAction("SaveImagesForExportExcel", "NpsAnalytics", "Survey");

            a4.callServerMethod(url, params, function (response) {
                if (response["RequestId"] && response["RequestId"] !== "00000000-0000-0000-0000-000000000000") {
                    postNpsTrendImageToServer(3, ".nps-TrendChart>.card", response["RequestId"]);
                }
            });
        });
    }

    function postNpsTrendImageToServer(chartType, selector, requestId) {
        html2canvas(document.querySelector(selector), { useCORS: true }).then(canvas => {
            var type = "png";
            var dataType = `image/${type}`;
            var imageContent = canvas.toDataURL(dataType).replace('data:' + dataType + ';base64,', '');

            var params = { surveyId: a4.getSurveyId(), npsChartType: chartType, imageContent: imageContent, inputRequestId: requestId };
            var url = a4.getAction("SaveImagesForExportExcel", "NpsAnalytics", "Survey");

            a4.callServerMethod(url, params, function (response) {
                if (response["RequestId"] && response["RequestId"] !== "00000000-0000-0000-0000-000000000000") {
                    generateAndDownloadExcelReport(response["RequestId"]);
                }
            });
        });
    }

    function generateAndDownloadExcelReport(requestId) {
        var feedbackQnsList = [];

        if (dashboardResults.selectedQnFeedbackQuestions !== null && dashboardResults.selectedQnFeedbackQuestions.length > 0) {
            dashboardResults.selectedQnFeedbackQuestions.forEach(function (feedbackQn) {
                if (feedbackQn.HasDashboard) {
                    feedbackQnsList.push({
                        "VariableId": feedbackQn.Variables[0].SourceKey,
                        "Name": feedbackQn.Name,
                        "Description": feedbackQn.Text
                    });
                }
            });
        }

        var params = {
            SurveyId: a4.getSurveyId(),
            SurveyName: document.getElementsByClassName("survey-name")[0].textContent,
            NpsQnVariableId: dashboardResults.selectedVariableId,
            NpsQnVariableName: dashboardResults.selectedVariableName,
            NpsQnDesc: dashboardResults.selectedQnDescription,
            NpsFeedbackQuestionsStringContent: JSON.stringify(feedbackQnsList),
            ReportGenerationRequestId: requestId,
            TopicsFilter: $(".nps-topic-sentimetOptions").val()
        };
        var url = a4.getAction("ExportToExcel", "NpsAnalytics", "Survey", params);
        window.location.href = url;
        setTimeout(() => {
            hideLoader();
        }, 3000);
    }
}

function getOpenEndAnswerResults(variableId, filterAnalytics) {
    if (dashboardResults.sentimentAnalysisTable) {
        dashboardResults.sentimentAnalysisTable.a4datatable("option", "ajaxParams", { "variableId": variableId });
        dashboardResults.sentimentAnalysisTable.a4datatable("refresh", true, true);
    }
    else {
        dashboardResults.sentimentAnalysisTable = $(".sentimet-analysis-table", dashboardResults.sentimentAnalysis).a4datatable({
            height: "full",
            ajaxAction: a4.getSurveyAction("GetOpenEndAnswers", "AdvancedAnalytics"),
            ajaxParams: { "variableId": variableId, "filterAnalytics": filterAnalytics, "filterVariableId": dashboardResults.selectedVariableId },
            columns: [
                {
                    "Name": "ResponseText", "Title": "SentimentAnalysis", "Data": function (source, type, val) {
                        var jqhtml = $("<div>")
                            .append($("<div>").addClass("response-container")
                                .append($("<div>").addClass(`response-sentiment-indicator ${source.SentimentAnalytics.toLowerCase()}`))
                                .append($("<div>").addClass("response-text").append(source.ResponseText))
                            );
                        return jqhtml.html();
                    }
                }
            ],
            localizableTexts: { "All": resources.Total, "Search": resources.SearchOpenEndQuestions },
            allowRowSelection: false,
            displayColumnSelector: false,
            displaySearchBox: false
        });
    }
}